<?php

function syncIt($refreshingMarkerFile, $currentVehiclesFilePath, callable $dataSyncFunction, $minutes = 50)
{
  global $isProd, $hash, $browser_language;
  $now = new DateTime();
  $now->setTimestamp(time());
  echo '$isProd: '. $isProd;
  if (file_exists($refreshingMarkerFile)) {
    $markerFileSecondsTriggeringRefresh = 30 * $minutes;

    $markerFileLastChangeDate = new DateTime();
    $markerFileLastChangeDate->setTimestamp(filemtime($refreshingMarkerFile));
    $markerFileSecondsElapsed = $now->getTimestamp() - $markerFileLastChangeDate->getTimestamp();

    if ($markerFileSecondsElapsed < 0 || $markerFileSecondsElapsed >= $markerFileSecondsTriggeringRefresh) {
      echo 'sync takes to long, starting over' . PHP_EOL;
      unlink($refreshingMarkerFile);
    } else {
      echo 'refresh already in progress, it started at ' . date_format($markerFileLastChangeDate, 'Y-m-d H:i:s') . ' UTC' . PHP_EOL;
      die();
    }
  }

  $fileLastChangeDate = new DateTime();
  $secondsElapsed = 0;
  if (file_exists($currentVehiclesFilePath)) {
    $fileLastChangeDate->setTimestamp(filemtime($currentVehiclesFilePath));
    $secondsElapsed = $now->getTimestamp() - $fileLastChangeDate->getTimestamp();
  } else {
    echo '$bemotoVehiclesFilePath does not exist, force sync\n';
    $secondsElapsed = 0; // Enforce refresh in dev environment when file doesn't exist
  }

  $secondsTriggeringRefresh = 0;
  if ($isProd) {
    $secondsTriggeringRefresh = 60 * $minutes;
    if ($secondsElapsed < 0) {
      if (file_exists($currentVehiclesFilePath)) {
        unlink($currentVehiclesFilePath);
      }
      $secondsElapsed = $secondsTriggeringRefresh; //enforce refresh
    }

    $nextRefreshInSeconds = $secondsTriggeringRefresh - $secondsElapsed;
    echo 'refreshes every: ' . ($secondsTriggeringRefresh / 60) . ' minutes | next refresh in: ' . floor($nextRefreshInSeconds / 60) . ' min ' . ($nextRefreshInSeconds % 60) . ' sec' . PHP_EOL;
  }
  // in dev environment refresh every time
  echo '$secondsElapsed: ' . $secondsElapsed . ', $secondsTriggeringRefresh: ' . $secondsTriggeringRefresh . PHP_EOL;
  if ($secondsElapsed >= $secondsTriggeringRefresh) {
    echo 'starting sync now' . PHP_EOL;
    touch($refreshingMarkerFile);
    $dataSyncFunction($hash, $browser_language);
    unlink($refreshingMarkerFile);
  }
}
