<?php

function add_bemoto_plugin_page($page_title = 'Bemoto Plugin Page', $page_content = '[bemoto_plugin]', $author_id = null)
{
  // Use current user ID if no author is specified
  if (is_null($author_id)) {
    $author_id = get_current_user_id();
  }

  // Use WP_Query to check if the page exists
  $args = array(
    'post_type'   => 'page',
    'title'       => $page_title,
    'post_status' => 'any',
    'posts_per_page' => 1
  );

  $page_query = new WP_Query($args);

  // Prepare the return data structure
  $result = [
    'postId'    => '',
    'postTitle' => $page_title,
    'permaLink' => '',
    'shortcode' => $page_content, // Optional field for shortcode
  ];

  // If page doesn't exist, create it
  if (!$page_query->have_posts()) {
    $new_page = array(
      'post_title'    => $page_title,
      'post_content'  => $page_content, // Dynamic content
      'post_status'   => 'publish',
      'post_type'     => 'page',
      'post_author'   => $author_id, // Dynamic author
    );

    // Insert the new page and get its ID
    $page_id = wp_insert_post($new_page);

    if ($page_id) {
      $page_url = get_permalink($page_id);

      // Fill in the result object
      $result['postId'] = (string) $page_id;
      $result['permaLink'] = $page_url;
    }
  } else {
    // If the page already exists, get its ID and permalink
    $existing_page = $page_query->posts[0];
    $result['postId'] = (string) $existing_page->ID;
    $result['permaLink'] = get_permalink($existing_page->ID);
  }

  // Reset post data after custom query
  wp_reset_postdata();

  // Return the result object
  return $result;
}
