<?php

function getPathFor($what, $hash = '', $locale = '')
{
  $upload_dir = wp_upload_dir(); // Get the uploads directory path
  $plugin_dir = $upload_dir['basedir'] . '/bemoto'; // e.g., wp-content/uploads/your-plugin-name

  if (empty($hash)) {
    return $plugin_dir . '/' . $what;
   }

  $pathToReturn = $plugin_dir . '/' . $hash;

  if (empty($locale)) {
    return $pathToReturn . '/' . $what ;
  } 

  $pathToReturn = $plugin_dir . '/' . $hash . '/' . $locale;

  return $pathToReturn . '/' . $what;
}

function deleteFolder($folderPath) {
    // Check if the path is a directory
    if (is_dir($folderPath)) {
        // Scan the folder and exclude `.` and `..`
        $files = array_diff(scandir($folderPath), array('.', '..'));

        // Loop through the folder contents
        foreach ($files as $file) {
            $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;

            // If it's a directory, call deleteFolder recursively
            if (is_dir($filePath)) {
                deleteFolder($filePath);
            } else {
                // If it's a file, delete it
                unlink($filePath);
            }
        }

        // Finally, remove the folder itself
        rmdir($folderPath);
    }
}

function getUrlContent($url)
{
  $curl = curl_init();

  curl_setopt_array($curl, array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_CONNECTTIMEOUT => 5,
    CURLOPT_TIMEOUT => 20,
    CURLOPT_SSL_VERIFYPEER => false
  ));

  $result = curl_exec($curl);

  $curl_errno = curl_errno($curl);
  $curl_error = curl_error($curl);
  $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
  curl_close($curl);

  $obj = new stdClass();
  $obj->status = $http_code;
  $obj->content = $result;
  $obj->errNo = $curl_errno;
  $obj->error = $curl_error;

  return $obj;
}

function getTimeDiffInSeconds($newLastSyncDateObj, $oldLastSyncDateObj){
  $interval = $oldLastSyncDateObj->diff($newLastSyncDateObj);
  return $interval->s + ($interval->i * 60) + ($interval->h * 3600) + ($interval->d * 86400) + ($interval->m * 2592000) + ($interval->y * 31536000);
}

function getTimeDiffInSecondsFormatted($newLastSyncDateObj, $oldLastSyncDateObj){
  $interval = $oldLastSyncDateObj->diff($newLastSyncDateObj);

  // Get the difference in total seconds
  $diffInSeconds = $interval->s + ($interval->i * 60) + ($interval->h * 3600) + ($interval->d * 86400) + ($interval->m * 2592000) + ($interval->y * 31536000);

  // Format the interval
  $formattedDiff = '';
  if ($interval->y > 0) {
    $formattedDiff .= $interval->y . ' year' . ($interval->y > 1 ? 's' : '') . ', ';
  }
  if ($interval->m > 0) {
    $formattedDiff .= $interval->m . ' month' . ($interval->m > 1 ? 's' : '') . ', ';
  }
  if ($interval->d > 0) {
    $formattedDiff .= $interval->d . ' day' . ($interval->d > 1 ? 's' : '') . ', ';
  }
  if ($interval->h > 0) {
    $formattedDiff .= $interval->h . ' hour' . ($interval->h > 1 ? 's' : '') . ', ';
  }
  if ($interval->i > 0) {
    $formattedDiff .= $interval->i . ' minute' . ($interval->i > 1 ? 's' : '') . ', ';
  }
  if ($interval->s > 0) {
    $formattedDiff .= $interval->s . ' second' . ($interval->s > 1 ? 's' : '');
  }

  // If the difference is 0, print "0 seconds"
  if (empty($formattedDiff)) {
    $formattedDiff = '0 seconds';
  }

  return $formattedDiff;
}
